<?xml version="1.0" encoding="utf-8"?>
<instrumentationManifest
  xmlns="http://schemas.microsoft.com/win/2004/08/events"
  xmlns:win="http://manifests.microsoft.com/win/2004/08/windows/events">
  <instrumentation>
    <events>
      <provider name="ControlUp-DataCollector-CitrixCloud" guid="{9A5DEAAB-F43C-4B7E-BF11-72319AF2D8E0}" symbol="CitrixCloud" resourceFileName="ControlUp.CitrixCloud.ETW.dll" messageFileName="ControlUp.CitrixCloud.ETW.dll">

        <channels>
          <channel name="ControlUp-DataCollector-CitrixCloud/Operational" chid="ControlUp-DataCollector-CitrixCloud/Operational" type="Operational" enabled="true" isolation="Application" />
        </channels>

        <events>
          <event symbol="DataCollectionStartedEvent" value="1000" template="DataCollectionStartedTemplate" message="$(string.DataCollectionStartedMessage)" level="win:Informational" version="0" opcode="win:Info" channel="ControlUp-DataCollector-CitrixCloud/Operational" />
          <event symbol="DataCollectionStoppedEvent" value="1001" template="DataCollectionStoppedTemplate" message="$(string.DataCollectionStoppedMessage)" level="win:Informational" version="0" opcode="win:Info" channel="ControlUp-DataCollector-CitrixCloud/Operational" />
          <event symbol="DataCollectedSuccessfullyEvent" value="1002" template="DataCollectedSuccessfullyTemplate" message="$(string.DataCollectedSuccessfullyMessage)" level="win:Informational" version="0" opcode="win:Info" channel="ControlUp-DataCollector-CitrixCloud/Operational" />
          <event symbol="ApiThrottlingEvent" value="2000" template="ApiThrottlingTemplate" message="$(string.ApiThrottlingMessage)" level="win:Warning" version="0" opcode="win:Info" channel="ControlUp-DataCollector-CitrixCloud/Operational" />
          <event symbol="SlowUpdateEvent" value="2001" template="SlowUpdateTemplate" message="$(string.SlowUpdateMessage)" level="win:Warning" version="0" opcode="win:Info" channel="ControlUp-DataCollector-CitrixCloud/Operational" />
          <event symbol="DataCollectedWithErrorsEvent" value="2002" template="DataCollectedWithErrorsTemplate" message="$(string.DataCollectedWithErrorsMessage)" level="win:Warning" version="0" opcode="win:Info" channel="ControlUp-DataCollector-CitrixCloud/Operational" />
          <event symbol="ApiCallFailedEvent" value="3000" template="ApiCallFailedTemplate" message="$(string.ApiCallFailedMessage)" level="win:Error" version="0" opcode="win:Info" channel="ControlUp-DataCollector-CitrixCloud/Operational" />
          <event symbol="DataCollectionFailedEvent" value="3001" template="DataCollectionFailedTemplate" message="$(string.DataCollectionFailedMessage)" level="win:Error" version="0" opcode="win:Info" channel="ControlUp-DataCollector-CitrixCloud/Operational" />
          <event symbol="LoginFailedEvent" value="3002" template="LoginFailedTemplate" message="$(string.LoginFailedMessage)" level="win:Error" version="0" opcode="win:Info" channel="ControlUp-DataCollector-CitrixCloud/Operational" />
        </events>

        <templates>
          <template tid="DataCollectionStartedTemplate">
            <data name="ConnectionId" inType="win:GUID" />
            <data name="ConnectionName" inType="win:UnicodeString" />
          </template>

          <template tid="DataCollectionStoppedTemplate">
            <data name="ConnectionId" inType="win:GUID" />
            <data name="ConnectionName" inType="win:UnicodeString" />
          </template>

          <template tid="DataCollectedSuccessfullyTemplate">
            <data name="ConnectionId" inType="win:GUID" />
            <data name="ConnectionName" inType="win:UnicodeString" />
            <data name="IsFullUpdate" inType="win:Boolean" />
            <data name="Duration" inType="win:UnicodeString" />
            <data name="ComputerCount" inType="win:Int32" />
            <data name="SessionCount" inType="win:Int32" />
            <data name="ApplicationCount" inType="win:Int32" />
            <data name="ApplicationInstanceCount" inType="win:Int32" />
            <data name="ConnectionFailureLogCount" inType="win:Int32" />
            <data name="DeliveryGroupCount" inType="win:Int32" />
            <data name="CatalogCount" inType="win:Int32" />
            <data name="CloudConnectorCount" inType="win:Int32" />
            <data name="ResourceLocationCount" inType="win:Int32" />
          </template>

          <template tid="ApiThrottlingTemplate">
            <data name="ConnectionId" inType="win:GUID" />
            <data name="ConnectionName" inType="win:UnicodeString" />
            <data name="EntityType" inType="win:UnicodeString" />
            <data name="URL" inType="win:UnicodeString" />
          </template>

          <template tid="SlowUpdateTemplate">
            <data name="ConnectionId" inType="win:GUID" />
            <data name="ConnectionName" inType="win:UnicodeString" />
            <data name="EntityType" inType="win:UnicodeString" />
            <data name="IsFullUpdate" inType="win:Boolean" />
            <data name="EntityCount" inType="win:Int32" />
            <data name="Duration" inType="win:UnicodeString" />
          </template>

          <template tid="DataCollectedWithErrorsTemplate">
            <data name="ConnectionId" inType="win:GUID" />
            <data name="ConnectionName" inType="win:UnicodeString" />
            <data name="IsFullUpdate" inType="win:Boolean" />
            <data name="Duration" inType="win:UnicodeString" />
            <data name="LastSuccessfulCollectionTime" inType="win:FILETIME" />
            <data name="ComputerCount" inType="win:Int32" />
            <data name="SessionCount" inType="win:Int32" />
            <data name="ApplicationCount" inType="win:Int32" />
            <data name="ApplicationInstanceCount" inType="win:Int32" />
            <data name="ConnectionFailureLogCount" inType="win:Int32" />
            <data name="DeliveryGroupCount" inType="win:Int32" />
            <data name="CatalogCount" inType="win:Int32" />
            <data name="CloudConnectorCount" inType="win:Int32" />
            <data name="ResourceLocationCount" inType="win:Int32" />
            <data name="Exception" inType="win:UnicodeString" />
          </template>

          <template tid="ApiCallFailedTemplate">
            <data name="ConnectionId" inType="win:GUID" />
            <data name="ConnectionName" inType="win:UnicodeString" />
            <data name="EntityType" inType="win:UnicodeString" />
            <data name="URL" inType="win:UnicodeString" />
            <data name="HttpStatusCode" inType="win:Int32" />
          </template>

          <template tid="DataCollectionFailedTemplate">
            <data name="ConnectionId" inType="win:GUID" />
            <data name="ConnectionName" inType="win:UnicodeString" />
            <data name="IsFullUpdate" inType="win:Boolean" />
            <data name="Duration" inType="win:UnicodeString" />
            <data name="Exception" inType="win:UnicodeString" />
          </template>

          <template tid="LoginFailedTemplate">
            <data name="ConnectionId" inType="win:GUID" />
            <data name="ConnectionName" inType="win:UnicodeString" />
            <data name="Exception" inType="win:UnicodeString" />
          </template>
        </templates>

      </provider>
    </events>
  </instrumentation>

  <localization>
    <resources culture="en-US">
      <stringTable>
        <string id="DataCollectionStartedMessage" value="Data collection started for connection '%2'"/>
        <string id="DataCollectionStoppedMessage" value="Data collection stopped for connection '%2'"/>
        <string id="DataCollectedSuccessfullyMessage" value="Data collected for connection '%2'"/>
        <string id="ApiThrottlingMessage" value="API call failed due to throttling for connection '%2'"/>
        <string id="SlowUpdateMessage" value="Update of %3 entity took %6 for connection '%2'"/>
        <string id="DataCollectedWithErrorsMessage" value="Data collected with errors for connection '%2'"/>
        <string id="ApiCallFailedMessage" value="API call failed with error %5 for connection '%2'"/>
        <string id="DataCollectionFailedMessage" value="Data collection failed for connection '%2'"/>
        <string id="LoginFailedMessage" value="Login failed for connection '%2'"/>
      </stringTable>
    </resources>
  </localization>

</instrumentationManifest>
